/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.config.Config;
import freenet.config.ConfigException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;

public class MISC
implements Step {
    private final Config config;
    private final NodeClientCore core;

    public MISC(NodeClientCore core, Config config) {
        this.core = core;
        this.config = config;
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("stepMiscTitle"));
        HTMLNode form = helper.addFormChild(contentNode, ".", "miscForm");
        HTMLNode miscInfoboxContent = helper.getInfobox("infobox-normal", WizardL10n.l10n("autoUpdate"), form, null, false);
        miscInfoboxContent.addChild("p", WizardL10n.l10n("autoUpdateLong"));
        miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value", "id"}, new String[]{"radio", "on", "autodeploy", "true", "autodeployTrue"}).addChild("label", new String[]{"for"}, new String[]{"autodeployTrue"}, WizardL10n.l10n("autoUpdateAutodeploy"));
        miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "autodeploy", "false", "autodeployFalse"}).addChild("label", new String[]{"for"}, new String[]{"autodeployFalse"}, WizardL10n.l10n("autoUpdateNoAutodeploy"));
        miscInfoboxContent = helper.getInfobox("infobox-normal", WizardL10n.l10n("plugins"), form, null, false);
        miscInfoboxContent.addChild("p", WizardL10n.l10n("pluginsLong"));
        miscInfoboxContent.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value", "id"}, new String[]{"checkbox", "on", "upnp", "true", "upnpTrue"}).addChild("label", new String[]{"for"}, new String[]{"upnpTrue"}, WizardL10n.l10n("enableUPnP"));
        miscInfoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
        miscInfoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "next", NodeL10n.getBase().getString("Toadlet.next")});
    }

    @Override
    public String postStep(HTTPRequest request) {
        this.setAutoUpdate(Boolean.parseBoolean(request.getPartAsStringFailsafe("autodeploy", 10)));
        this.setUPnP(request.isPartSet("upnp"));
        return FirstTimeWizardToadlet.WIZARD_STEP.OPENNET.name();
    }

    public void setAutoUpdate(boolean enabled) {
        try {
            this.config.get("node.updater").set("autoupdate", enabled);
        }
        catch (ConfigException e) {
            Logger.error(this, "Should not happen, please report!" + e, (Throwable)e);
        }
    }

    public void setUPnP(final boolean enableUPnP) {
        if (enableUPnP == this.core.getNode().getPluginManager().isPluginLoaded("plugins.UPnP.UPnP")) {
            return;
        }
        this.core.getNode().getExecutor().execute(new Runnable(){
            private final boolean enable;
            {
                this.enable = enableUPnP;
            }

            @Override
            public void run() {
                if (this.enable) {
                    MISC.this.core.getNode().getPluginManager().startPluginOfficial("UPnP", true);
                } else {
                    MISC.this.core.getNode().getPluginManager().killPluginByClass("plugins.UPnP.UPnP", 5000L);
                }
            }
        });
    }
}

