/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.ajaxpush;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.RedirectException;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class PushFailoverToadlet
extends Toadlet {
    private static volatile boolean logMINOR;

    public PushFailoverToadlet(HighLevelSimpleClient client) {
        super(client);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        String requestId = req.getParam("requestId");
        String originalRequestId = req.getParam("originalRequestId");
        boolean result = ((SimpleToadletServer)ctx.getContainer()).getPushDataManager().failover(originalRequestId, requestId);
        if (logMINOR) {
            Logger.minor(this, "Failover from:" + originalRequestId + " to:" + requestId + " with result:" + result);
        }
        this.writeHTMLReply(ctx, 200, "OK", result ? "SUCCESS" : "FAILURE");
    }

    @Override
    public String path() {
        return "/failover/";
    }

    static {
        Logger.registerClass(PushFailoverToadlet.class);
    }
}

