/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.TooManyFilesInsertException;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.ClientGetMessage;
import freenet.clients.fcp.ClientPut;
import freenet.clients.fcp.ClientPutDir;
import freenet.clients.fcp.ClientPutDirMessage;
import freenet.clients.fcp.ClientPutMessage;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionInputHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FCPPluginConnection;
import freenet.clients.fcp.FCPPluginConnectionImpl;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.IdentifierCollisionMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.clients.fcp.SubscribeUSK;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.BucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FCPConnectionHandler
implements Closeable {
    @Deprecated
    final FCPServer server;
    @Deprecated
    final Socket sock;
    final FCPConnectionInputHandler inputHandler;
    final Map<String, SubscribeUSK> uskSubscriptions;
    @Deprecated
    public final FCPConnectionOutputHandler outputHandler;
    private boolean isClosed;
    private boolean inputClosed;
    private boolean outputClosed;
    private String clientName;
    private PersistentRequestClient rebootClient;
    private PersistentRequestClient foreverClient;
    final BucketFactory bf;
    final HashMap<String, ClientRequest> requestsByIdentifier;
    private final TreeMap<String, FCPPluginConnectionImpl> pluginConnectionsByServerName = new TreeMap();
    private final ReadWriteLock pluginConnectionsByServerName_Lock = new ReentrantReadWriteLock();
    @Deprecated
    public final String connectionIdentifier;
    protected final UUID connectionIdentifierUUID;
    private static volatile boolean logMINOR;
    private boolean killedDupe;
    private final HashMap<String, DirectoryAccess> checkedDirectories = new HashMap();
    private final HashMap<File, DDACheckJob> inTestDirectories = new HashMap();
    public final RequestClient connectionRequestClientBulk = new RequestClientBuilder().build();
    public final RequestClient connectionRequestClientRT = new RequestClientBuilder().realTime().build();

    public FCPConnectionHandler(Socket s, FCPServer server) {
        this.sock = s;
        this.server = server;
        this.isClosed = false;
        this.bf = server.getCore().getTempBucketFactory();
        this.requestsByIdentifier = new HashMap();
        this.uskSubscriptions = new HashMap<String, SubscribeUSK>();
        this.inputHandler = new FCPConnectionInputHandler(this);
        this.outputHandler = new FCPConnectionOutputHandler(this);
        byte[] identifier = new byte[16];
        server.getNode().getRandom().nextBytes(identifier);
        this.connectionIdentifier = HexUtil.bytesToHex(identifier);
        this.connectionIdentifierUUID = UUID.nameUUIDFromBytes(identifier);
    }

    public final void send(FCPMessage message) {
        this.outputHandler.queue(message);
    }

    void start() {
        this.inputHandler.start();
        this.outputHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.rebootClient != null) {
            this.rebootClient.onLostConnection((FCPConnectionHandler)this);
        }
        if (this.foreverClient != null) {
            this.foreverClient.onLostConnection((FCPConnectionHandler)this);
        }
        Object[] objectArray = this;
        synchronized (this) {
            if (this.isClosed) {
                // ** MonitorExit[var4_1] (shouldn't be in output)
                return;
            }
            this.isClosed = true;
            ClientRequest[] requests = new ClientRequest[this.requestsByIdentifier.size()];
            requests = this.requestsByIdentifier.values().toArray(requests);
            this.requestsByIdentifier.clear();
            SubscribeUSK[] uskSubscriptions2 = this.uskSubscriptions.values().toArray(new SubscribeUSK[this.uskSubscriptions.size()]);
            boolean dupe = this.killedDupe;
            // ** MonitorExit[var4_1] (shouldn't be in output)
            for (ClientRequest req : requests) {
                req.onLostConnection(this.server.getCore().getClientContext());
            }
            for (SubscribeUSK sub : uskSubscriptions2) {
                sub.unsubscribe();
            }
            if (!dupe) {
                try {
                    this.server.getCore().getClientContext().jobRunner.queue(new PersistentJob(){

                        @Override
                        public boolean run(ClientContext context) {
                            if (FCPConnectionHandler.this.rebootClient != null && !FCPConnectionHandler.this.rebootClient.hasPersistentRequests()) {
                                FCPConnectionHandler.this.server.unregisterClient(FCPConnectionHandler.this.rebootClient);
                            }
                            if (FCPConnectionHandler.this.foreverClient != null && !FCPConnectionHandler.this.foreverClient.hasPersistentRequests()) {
                                FCPConnectionHandler.this.server.unregisterClient(FCPConnectionHandler.this.foreverClient);
                            }
                            return false;
                        }
                    }, NativeThread.NORM_PRIORITY);
                }
                catch (PersistenceDisabledException persistenceDisabledException) {
                    // empty catch block
                }
            }
            this.outputHandler.onClosed();
            return;
        }
    }

    synchronized void setKilledDupe() {
        this.killedDupe = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedInput() {
        try {
            this.sock.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            this.inputClosed = true;
            if (!this.outputClosed) {
                return;
            }
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedOutput() {
        try {
            this.sock.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            this.outputClosed = true;
            if (!this.inputClosed) {
                return;
            }
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientName(String name) {
        PersistentRequestClient client;
        this.clientName = name;
        this.rebootClient = this.server.registerRebootClient(name, this.server.getCore(), this);
        this.rebootClient.queuePendingMessagesOnConnectionRestartAsync(this.outputHandler, this.server.getCore().getClientContext());
        if (logMINOR) {
            Logger.minor(this, "Set client name: " + name);
        }
        if ((client = this.server.getForeverClient(name, this.server.getCore(), this)) != null) {
            FCPConnectionHandler fCPConnectionHandler = this;
            synchronized (fCPConnectionHandler) {
                this.foreverClient = client;
            }
            this.foreverClient.queuePendingMessagesOnConnectionRestartAsync(this.outputHandler, this.server.getCore().getClientContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistentRequestClient createForeverClient(String name) {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.foreverClient != null) {
                return this.foreverClient;
            }
        }
        PersistentRequestClient client = this.server.registerForeverClient(name, this.server.getCore(), this);
        FCPConnectionHandler fCPConnectionHandler2 = this;
        synchronized (fCPConnectionHandler2) {
            this.foreverClient = client;
            this.notifyAll();
        }
        client.queuePendingMessagesOnConnectionRestartAsync(this.outputHandler, this.server.getCore().getClientContext());
        return this.foreverClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientGet(final ClientGetMessage message) {
        boolean success;
        final String id = message.identifier;
        final boolean global = message.global;
        ClientGet cg = null;
        boolean persistent = message.persistence != ClientRequest.Persistence.CONNECTION;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            block18: {
                if (this.isClosed) {
                    return;
                }
                if (persistent) {
                    success = true;
                } else {
                    boolean bl = success = !this.requestsByIdentifier.containsKey(id);
                }
                if (success) {
                    try {
                        if (!persistent) {
                            cg = new ClientGet(this, message, this.server.getCore());
                            this.requestsByIdentifier.put(id, cg);
                            break block18;
                        }
                        if (message.persistence == ClientRequest.Persistence.FOREVER) {
                            try {
                                this.server.getCore().getClientContext().jobRunner.queue(new PersistentJob(){

                                    @Override
                                    public boolean run(ClientContext context) {
                                        ClientGet getter;
                                        try {
                                            getter = new ClientGet(FCPConnectionHandler.this, message, FCPConnectionHandler.this.server.getCore());
                                        }
                                        catch (IdentifierCollisionException e1) {
                                            Logger.normal(this, "Identifier collision on " + this);
                                            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                            FCPConnectionHandler.this.outputHandler.queue(msg);
                                            return false;
                                        }
                                        catch (MessageInvalidException e1) {
                                            FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(e1.protocolCode, false, e1.getMessage(), e1.ident, e1.global));
                                            return false;
                                        }
                                        try {
                                            getter.register(false);
                                        }
                                        catch (IdentifierCollisionException e) {
                                            Logger.normal(this, "Identifier collision on " + this);
                                            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                            FCPConnectionHandler.this.outputHandler.queue(msg);
                                            return false;
                                        }
                                        getter.start(context);
                                        return true;
                                    }
                                }, NativeThread.HIGH_PRIORITY - 1);
                            }
                            catch (PersistenceDisabledException e) {
                                this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                                return;
                            }
                            return;
                        }
                        cg = new ClientGet(this, message, this.server.getCore());
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                }
            }
        }
        if (message.persistence == ClientRequest.Persistence.REBOOT) {
            try {
                cg.register(false);
            }
            catch (IdentifierCollisionException e) {
                success = false;
            }
        }
        if (!success) {
            Logger.normal(this, "Identifier collision on " + this);
            IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
            this.outputHandler.queue(msg);
            return;
        }
        cg.start(this.server.getCore().getClientContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientPut(final ClientPutMessage message) {
        if (logMINOR) {
            Logger.minor(this, "Starting insert ID=\"" + message.identifier + '\"');
        }
        final String id = message.identifier;
        final boolean global = message.global;
        ClientPut cp = null;
        boolean persistent = message.persistence != ClientRequest.Persistence.CONNECTION;
        FCPMessage failedMessage = null;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            boolean success;
            if (this.isClosed) {
                if (logMINOR) {
                    Logger.minor(this, "Connection is closed");
                }
                return;
            }
            if (persistent) {
                success = true;
            } else {
                boolean bl = success = !this.requestsByIdentifier.containsKey(id);
            }
            if (success) {
                if (!persistent) {
                    try {
                        cp = new ClientPut(this, message, this.server);
                        this.requestsByIdentifier.put(id, cp);
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                    catch (MalformedURLException e) {
                        failedMessage = new ProtocolErrorMessage(4, true, e.getMessage(), id, message.global);
                    }
                    catch (IOException e) {
                        failedMessage = new ProtocolErrorMessage(37, true, e.getMessage(), id, message.global);
                    }
                } else {
                    if (message.persistence == ClientRequest.Persistence.FOREVER) {
                        try {
                            this.server.getCore().getClientContext().jobRunner.queue(new PersistentJob(){

                                @Override
                                public boolean run(ClientContext context) {
                                    ClientPut putter;
                                    try {
                                        putter = new ClientPut(FCPConnectionHandler.this, message, FCPConnectionHandler.this.server);
                                    }
                                    catch (IdentifierCollisionException e) {
                                        Logger.normal(this, "Identifier collision on " + this);
                                        IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                        FCPConnectionHandler.this.outputHandler.queue(msg);
                                        return false;
                                    }
                                    catch (MessageInvalidException e) {
                                        FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                                        return false;
                                    }
                                    catch (MalformedURLException e) {
                                        FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(4, true, null, id, message.global));
                                        return false;
                                    }
                                    catch (IOException e) {
                                        FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(37, true, null, id, message.global));
                                        return false;
                                    }
                                    try {
                                        putter.register(false);
                                    }
                                    catch (IdentifierCollisionException e) {
                                        Logger.normal(this, "Identifier collision on " + this);
                                        IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                        FCPConnectionHandler.this.outputHandler.queue(msg);
                                        return false;
                                    }
                                    putter.start(context);
                                    return true;
                                }
                            }, NativeThread.HIGH_PRIORITY - 1);
                        }
                        catch (PersistenceDisabledException e) {
                            this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                        }
                        return;
                    }
                    try {
                        cp = new ClientPut(this, message, this.server);
                    }
                    catch (IdentifierCollisionException e) {
                        success = false;
                    }
                    catch (MessageInvalidException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global));
                        return;
                    }
                    catch (MalformedURLException e) {
                        failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                    }
                    catch (IOException e) {
                        failedMessage = new ProtocolErrorMessage(37, true, null, id, message.global);
                    }
                }
            }
            if (!success) {
                Logger.normal(this, "Identifier collision on " + this);
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (message.persistence == ClientRequest.Persistence.REBOOT && cp != null) {
            try {
                cp.register(false);
            }
            catch (IdentifierCollisionException e) {
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (failedMessage != null) {
            if (logMINOR) {
                Logger.minor(this, "Failed: " + failedMessage);
            }
            this.outputHandler.queue(failedMessage);
            if (cp != null) {
                cp.freeData();
            } else {
                message.freeData();
            }
            return;
        }
        Logger.minor(this, "Starting " + cp);
        cp.start(this.server.getCore().getClientContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startClientPutDir(final ClientPutDirMessage message, final HashMap<String, Object> buckets, final boolean wasDiskPut) {
        boolean success;
        if (logMINOR) {
            Logger.minor(this, "Start ClientPutDir");
        }
        final String id = message.identifier;
        final boolean global = message.global;
        ClientPutDir cp = null;
        FCPMessage failedMessage = null;
        boolean persistent = message.persistence != ClientRequest.Persistence.CONNECTION;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.isClosed) {
                return;
            }
            success = !persistent ? true : !this.requestsByIdentifier.containsKey(id);
        }
        if (success) {
            if (!persistent) {
                try {
                    cp = new ClientPutDir(this, message, buckets, wasDiskPut, this.server);
                    fCPConnectionHandler = this;
                    synchronized (fCPConnectionHandler) {
                        this.requestsByIdentifier.put(id, cp);
                    }
                }
                catch (IdentifierCollisionException e) {
                    success = false;
                }
                catch (MalformedURLException e) {
                    failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                }
                catch (TooManyFilesInsertException e) {
                    failedMessage = new ProtocolErrorMessage(34, true, null, id, message.global);
                }
            } else {
                if (message.persistence == ClientRequest.Persistence.FOREVER) {
                    try {
                        this.server.getCore().getClientContext().jobRunner.queue(new PersistentJob(){

                            @Override
                            public boolean run(ClientContext context) {
                                ClientPutDir putter;
                                try {
                                    putter = new ClientPutDir(FCPConnectionHandler.this, message, buckets, wasDiskPut, FCPConnectionHandler.this.server);
                                }
                                catch (IdentifierCollisionException e) {
                                    Logger.normal(this, "Identifier collision on " + this);
                                    IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, message.global);
                                    FCPConnectionHandler.this.outputHandler.queue(msg);
                                    return false;
                                }
                                catch (MalformedURLException e) {
                                    FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(4, true, null, id, message.global));
                                    return false;
                                }
                                catch (TooManyFilesInsertException e) {
                                    FCPConnectionHandler.this.outputHandler.queue(new ProtocolErrorMessage(34, true, null, id, message.global));
                                    return false;
                                }
                                try {
                                    putter.register(false);
                                }
                                catch (IdentifierCollisionException e) {
                                    Logger.normal(this, "Identifier collision on " + this);
                                    IdentifierCollisionMessage msg = new IdentifierCollisionMessage(id, global);
                                    FCPConnectionHandler.this.outputHandler.queue(msg);
                                    return false;
                                }
                                putter.start(context);
                                return true;
                            }
                        }, NativeThread.HIGH_PRIORITY - 1);
                    }
                    catch (PersistenceDisabledException e) {
                        this.outputHandler.queue(new ProtocolErrorMessage(33, false, "Persistence is disabled", id, global));
                    }
                    return;
                }
                try {
                    cp = new ClientPutDir(this, message, buckets, wasDiskPut, this.server);
                }
                catch (IdentifierCollisionException e) {
                    success = false;
                }
                catch (MalformedURLException e) {
                    failedMessage = new ProtocolErrorMessage(4, true, null, id, message.global);
                }
                catch (TooManyFilesInsertException e) {
                    failedMessage = new ProtocolErrorMessage(34, true, null, id, message.global);
                }
            }
            if (!success) {
                Logger.normal(this, "Identifier collision on " + this);
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (message.persistence == ClientRequest.Persistence.REBOOT) {
            try {
                cp.register(false);
            }
            catch (IdentifierCollisionException e) {
                failedMessage = new IdentifierCollisionMessage(id, message.global);
            }
        }
        if (failedMessage != null) {
            this.outputHandler.queue(failedMessage);
            if (cp != null) {
                cp.cancel(this.server.getCore().getClientContext());
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Starting " + cp);
        }
        cp.start(this.server.getCore().getClientContext());
    }

    public PersistentRequestClient getRebootClient() {
        return this.rebootClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FCPPluginConnection getFCPPluginConnection(String serverPluginName) throws PluginNotFoundException {
        this.pluginConnectionsByServerName_Lock.readLock().lock();
        try {
            FCPPluginConnectionImpl peekOldConnection = this.pluginConnectionsByServerName.get(serverPluginName);
            if (peekOldConnection != null && !peekOldConnection.isServerDead()) {
                FCPPluginConnectionImpl fCPPluginConnectionImpl = peekOldConnection;
                return fCPPluginConnectionImpl;
            }
        }
        finally {
            this.pluginConnectionsByServerName_Lock.readLock().unlock();
        }
        this.pluginConnectionsByServerName_Lock.writeLock().lock();
        try {
            FCPPluginConnectionImpl oldConnection = this.pluginConnectionsByServerName.get(serverPluginName);
            if (oldConnection != null) {
                if (!oldConnection.isServerDead()) {
                    FCPPluginConnectionImpl fCPPluginConnectionImpl = oldConnection;
                    return fCPPluginConnectionImpl;
                }
                this.pluginConnectionsByServerName.remove(serverPluginName);
            }
            FCPPluginConnectionImpl newConnection = this.server.createFCPPluginConnectionForNetworkedFCP(serverPluginName, this);
            this.pluginConnectionsByServerName.put(serverPluginName, newConnection);
            FCPPluginConnectionImpl fCPPluginConnectionImpl = newConnection;
            return fCPPluginConnectionImpl;
        }
        finally {
            this.pluginConnectionsByServerName_Lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentRequestClient getForeverClient() {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            if (this.foreverClient == null) {
                this.foreverClient = this.createForeverClient(this.clientName);
            }
            return this.foreverClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedClientRequest(ClientRequest get) {
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            this.requestsByIdentifier.remove(get.getIdentifier());
        }
    }

    public boolean isGlobalSubscribed() {
        return this.rebootClient.watchGlobal;
    }

    public boolean hasFullAccess() {
        return this.server.allowedHostsFullAccess.allowed(this.sock.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowDDAFrom(File filename, boolean writeRequest) {
        String parentDirectory = FileUtil.getCanonicalFile(filename).getParent();
        DirectoryAccess da = null;
        HashMap<String, DirectoryAccess> hashMap = this.checkedDirectories;
        synchronized (hashMap) {
            da = this.checkedDirectories.get(parentDirectory);
        }
        if (logMINOR) {
            Logger.minor(this, "Checking DDA: " + da + " for " + parentDirectory);
        }
        if (writeRequest) {
            return da == null ? this.server.isDownloadDDAAlwaysAllowed() : da.canWrite;
        }
        return da == null ? this.server.isUploadDDAAlwaysAllowed() : da.canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerTestDDAResult(String path, boolean read, boolean write) {
        DirectoryAccess da = new DirectoryAccess(read, write);
        HashMap<String, DirectoryAccess> hashMap = this.checkedDirectories;
        synchronized (hashMap) {
            this.checkedDirectories.put(path, da);
        }
        if (logMINOR) {
            Logger.minor(this, "DDA: read=" + read + " write=" + write + " for " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DDACheckJob enqueueDDACheck(String path, boolean read, boolean write) throws IllegalArgumentException {
        File directory = FileUtil.getCanonicalFile(new File(path));
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("The specified path isn't a directory! or doesn't exist or the node doesn't have access to it!");
        }
        DDACheckJob job = null;
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            job = this.inTestDirectories.get(directory);
        }
        if (job != null) {
            throw new IllegalArgumentException("There is already a TestDDA going on for that directory!");
        }
        File writeFile = write ? new File(path, "DDACheck-" + this.server.getNode().getFastWeakRandom().nextInt() + ".tmp") : null;
        File readFile = null;
        if (read) {
            try {
                readFile = File.createTempFile("DDACheck-", ".tmp", directory);
                readFile.deleteOnExit();
            }
            catch (IOException e) {
                readFile = null;
            }
        }
        DDACheckJob result = new DDACheckJob(this.server.getNode().getFastWeakRandom(), directory, readFile, writeFile);
        HashMap<File, DDACheckJob> hashMap2 = this.inTestDirectories;
        synchronized (hashMap2) {
            this.inTestDirectories.put(directory, result);
        }
        if (read && readFile != null && readFile.canWrite()) {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                fos = new FileOutputStream(result.readFilename);
                bos = new BufferedOutputStream(fos);
                bos.write(result.readContent.getBytes(StandardCharsets.UTF_8));
                bos.flush();
            }
            catch (IOException e) {
                try {
                    Logger.error(this, "Got a IOE while creating the file (" + readFile.toString() + " ! " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Closer.close(bos);
                    Closer.close(fos);
                    throw throwable;
                }
                Closer.close(bos);
                Closer.close(fos);
            }
            Closer.close(bos);
            Closer.close(fos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DDACheckJob popDDACheck(String path) throws IllegalArgumentException {
        File directory = FileUtil.getCanonicalFile(new File(path));
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("The specified path isn't a directory! or doesn't exist or the node doesn't have access to it!");
        }
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            return this.inTestDirectories.remove(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeDDAJobs() {
        HashMap<File, DDACheckJob> hashMap = this.inTestDirectories;
        synchronized (hashMap) {
            for (DDACheckJob job : this.inTestDirectories.values()) {
                if (job.readFilename == null) continue;
                job.readFilename.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRequest removeRequestByIdentifier(String identifier, boolean kill) {
        ClientRequest req;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            req = this.requestsByIdentifier.remove(identifier);
        }
        if (req != null) {
            if (kill) {
                req.cancel(this.server.getCore().getClientContext());
            }
            req.requestWasRemoved(this.server.getCore().getClientContext());
        }
        return req;
    }

    ClientRequest getRebootRequest(boolean global, FCPConnectionHandler handler, String identifier) {
        if (global) {
            return handler.server.getGlobalRebootClient().getRequest(identifier);
        }
        return handler.getRebootClient().getRequest(identifier);
    }

    ClientRequest getForeverRequest(boolean global, FCPConnectionHandler handler, String identifier) {
        if (global) {
            return handler.server.getGlobalForeverClient().getRequest(identifier);
        }
        return handler.getForeverClient().getRequest(identifier);
    }

    ClientRequest removePersistentRebootRequest(boolean global, String identifier) throws MessageInvalidException {
        PersistentRequestClient client = global ? this.server.getGlobalRebootClient() : this.getRebootClient();
        ClientRequest req = client.getRequest(identifier);
        if (req != null) {
            client.removeByIdentifier(identifier, true, this.server, this.server.getCore().getClientContext());
        }
        return req;
    }

    ClientRequest removePersistentForeverRequest(boolean global, String identifier) throws MessageInvalidException {
        PersistentRequestClient client = global ? this.server.getGlobalForeverClient() : this.getForeverClient();
        ClientRequest req = client.getRequest(identifier);
        if (req != null) {
            client.removeByIdentifier(identifier, true, this.server, this.server.getCore().getClientContext());
        }
        return req;
    }

    public synchronized void addUSKSubscription(String identifier, SubscribeUSK subscribeUSK) throws IdentifierCollisionException {
        if (this.uskSubscriptions.containsKey(identifier)) {
            throw new IdentifierCollisionException();
        }
        this.uskSubscriptions.put(identifier, subscribeUSK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeUSK(String identifier) throws MessageInvalidException {
        SubscribeUSK sub;
        FCPConnectionHandler fCPConnectionHandler = this;
        synchronized (fCPConnectionHandler) {
            sub = this.uskSubscriptions.remove(identifier);
            if (sub == null) {
                throw new MessageInvalidException(15, "No such identifier unsubscribing", identifier, false);
            }
        }
        sub.unsubscribe();
    }

    public RequestClient connectionRequestClient(boolean realTime) {
        if (realTime) {
            return this.connectionRequestClientRT;
        }
        return this.connectionRequestClientBulk;
    }

    public FCPServer getServer() {
        return this.server;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public FCPConnectionOutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class DDACheckJob {
        final File directory;
        final File readFilename;
        final File writeFilename;
        final String readContent;
        final String writeContent;

        DDACheckJob(Random r, File directory, File readFilename, File writeFilename) {
            this.directory = directory;
            this.readFilename = readFilename;
            this.writeFilename = writeFilename;
            byte[] random = new byte[128];
            r.nextBytes(random);
            this.readContent = HexUtil.bytesToHex(random);
            r.nextBytes(random);
            this.writeContent = HexUtil.bytesToHex(random);
        }
    }

    private static final class DirectoryAccess {
        final boolean canWrite;
        final boolean canRead;

        public DirectoryAccess(boolean canRead, boolean canWrite) {
            this.canRead = canRead;
            this.canWrite = canWrite;
        }
    }
}

