/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPServer;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.PersistentRequestModifiedMessage;
import freenet.clients.fcp.RequestIdentifier;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.RequestStatusCache;
import freenet.crypt.ChecksumChecker;
import freenet.keys.FreenetURI;
import freenet.node.PrioRunnable;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class ClientRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected FreenetURI uri;
    protected final String identifier;
    protected final int verbosity;
    protected final transient FCPConnectionHandler origHandler;
    protected final boolean global;
    protected final String clientName;
    protected transient PersistentRequestClient client;
    protected short priorityClass;
    protected final boolean realTime;
    protected final Persistence persistence;
    protected boolean finished;
    protected String clientToken;
    protected final long startupTime;
    protected long completionTime;
    protected transient RequestClient lowLevelClient;
    private final int hashCode;
    private static volatile boolean logMINOR;
    protected boolean started;
    private static final long CLIENT_DETAIL_MAGIC = -1445456516116158687L;
    private static final int CLIENT_DETAIL_VERSION = 1;

    public int hashCode() {
        return this.hashCode;
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, String charset, FCPConnectionHandler handler, PersistentRequestClient client, short priorityClass2, Persistence persistenceType2, boolean realTime, String clientToken2, boolean global) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        if (global) {
            this.verbosity = Integer.MAX_VALUE;
            this.clientName = null;
        } else {
            this.verbosity = verbosity2;
            this.clientName = client.name;
        }
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistence = persistenceType2;
        this.clientToken = clientToken2;
        this.global = global;
        if (this.persistence == Persistence.CONNECTION) {
            this.origHandler = handler;
            this.lowLevelClient = this.origHandler.connectionRequestClient(realTime);
            this.client = null;
        } else {
            this.origHandler = null;
            this.client = client;
            assert (client != null);
            assert (client.persistence == this.persistence);
            this.lowLevelClient = client.lowLevelClient(realTime);
        }
        assert (this.lowLevelClient != null);
        this.startupTime = System.currentTimeMillis();
        this.realTime = realTime;
    }

    public ClientRequest(FreenetURI uri2, String identifier2, int verbosity2, String charset, FCPConnectionHandler handler, short priorityClass2, Persistence persistenceType2, boolean realTime, String clientToken2, boolean global) {
        int hash = super.hashCode();
        if (hash == 0) {
            hash = 1;
        }
        this.hashCode = hash;
        this.uri = uri2;
        this.identifier = identifier2;
        this.finished = false;
        this.priorityClass = priorityClass2;
        this.persistence = persistenceType2;
        this.clientToken = clientToken2;
        this.global = global;
        if (this.persistence == Persistence.CONNECTION) {
            this.origHandler = handler;
            this.client = null;
            this.lowLevelClient = new RequestClientBuilder().realTime(realTime).build();
            this.clientName = null;
            this.verbosity = verbosity2;
        } else {
            this.origHandler = null;
            if (global) {
                this.client = this.persistence == Persistence.FOREVER ? handler.getServer().getGlobalForeverClient() : handler.getServer().getGlobalRebootClient();
                this.verbosity = Integer.MAX_VALUE;
                this.clientName = null;
            } else {
                this.client = this.persistence == Persistence.FOREVER ? handler.getForeverClient() : handler.getRebootClient();
                this.verbosity = verbosity2;
                this.clientName = this.client.name;
            }
            this.lowLevelClient = this.client.lowLevelClient(realTime);
            if (this.lowLevelClient == null) {
                throw new NullPointerException("No lowLevelClient from client: " + this.client + " global = " + global + " persistence = " + (Object)((Object)this.persistence));
            }
        }
        if (this.lowLevelClient.persistent() != (this.persistence == Persistence.FOREVER)) {
            throw new IllegalStateException("Low level client.persistent=" + this.lowLevelClient.persistent() + " but persistence type = " + (Object)((Object)this.persistence));
        }
        if (this.client != null) assert (this.client.persistence == this.persistence);
        this.startupTime = System.currentTimeMillis();
        this.realTime = realTime;
    }

    protected ClientRequest() {
        this.identifier = null;
        this.verbosity = 0;
        this.origHandler = null;
        this.global = false;
        this.clientName = null;
        this.realTime = false;
        this.persistence = null;
        this.startupTime = 0L;
        this.hashCode = 0;
    }

    public abstract void onLostConnection(ClientContext var1);

    public abstract void sendPendingMessages(FCPConnectionOutputHandler var1, String var2, boolean var3, boolean var4);

    abstract void register(boolean var1) throws IdentifierCollisionException;

    public void cancel(ClientContext context) {
        ClientRequester cr = this.getClientRequest();
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + cr + " for " + this + " persistence = " + (Object)((Object)this.persistence));
        }
        if (cr != null) {
            cr.cancel(context);
        }
        this.freeData();
    }

    public boolean isPersistentForever() {
        return this.persistence == Persistence.FOREVER;
    }

    public boolean isPersistent() {
        return this.persistence != Persistence.CONNECTION;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected abstract ClientRequester getClientRequest();

    public void dropped(ClientContext context) {
        this.cancel(context);
        this.freeData();
    }

    public short getPriority() {
        return this.priorityClass;
    }

    protected abstract void freeData();

    protected void finish() {
        if (this.persistence == Persistence.CONNECTION) {
            this.origHandler.finishedClientRequest(this);
        } else {
            this.client.finishedClientRequest(this);
        }
    }

    public abstract double getSuccessFraction();

    public abstract double getTotalBlocks();

    public abstract double getMinBlocks();

    public abstract double getFetchedBlocks();

    public abstract double getFailedBlocks();

    public abstract double getFatalyFailedBlocks();

    public abstract String getFailureReason(boolean var1);

    public abstract boolean isTotalFinalized();

    public abstract void start(ClientContext var1);

    public boolean isStarted() {
        return this.started;
    }

    public abstract boolean hasSucceeded();

    @Deprecated
    public long getLastActivity() {
        ClientRequester cr = this.getClientRequest();
        if (cr == null) {
            return 0L;
        }
        return cr.getLatestSuccess().getTime();
    }

    public abstract boolean canRestart();

    public abstract boolean restart(ClientContext var1, boolean var2) throws PersistenceDisabledException;

    public void modifyRequest(String newClientToken, short newPriorityClass, FCPServer server) {
        PersistentRequestModifiedMessage modifiedMsg;
        boolean clientTokenChanged = false;
        boolean priorityClassChanged = false;
        if (newClientToken != null) {
            if (this.clientToken != null) {
                if (!newClientToken.equals(this.clientToken)) {
                    this.clientToken = newClientToken;
                    clientTokenChanged = true;
                }
            } else {
                this.clientToken = newClientToken;
                clientTokenChanged = true;
            }
        }
        if (newPriorityClass >= 0 && newPriorityClass != this.priorityClass) {
            RequestStatusCache cache;
            this.priorityClass = newPriorityClass;
            ClientRequester r = this.getClientRequest();
            r.setPriorityClass(this.priorityClass, server.getCore().getClientContext());
            priorityClassChanged = true;
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.setPriority(this.identifier, newPriorityClass);
            }
        }
        if (!clientTokenChanged && !priorityClassChanged) {
            return;
        }
        server.getCore().getClientContext().jobRunner.setCheckpointASAP();
        if (clientTokenChanged && priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass, this.clientToken);
        } else if (priorityClassChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.priorityClass);
        } else if (clientTokenChanged) {
            modifiedMsg = new PersistentRequestModifiedMessage(this.identifier, this.global, this.clientToken);
        } else {
            return;
        }
        this.client.queueClientRequestMessage(modifiedMsg, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartAsync(final FCPServer server, final boolean disableFilterData) throws PersistenceDisabledException {
        RequestStatusCache cache;
        ClientRequest clientRequest = this;
        synchronized (clientRequest) {
            this.started = false;
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateStarted(this.identifier, false);
        }
        if (this.persistence == Persistence.FOREVER) {
            server.getCore().getClientContext().jobRunner.queue(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    try {
                        ClientRequest.this.restart(context, disableFilterData);
                    }
                    catch (PersistenceDisabledException persistenceDisabledException) {
                        // empty catch block
                    }
                    return true;
                }
            }, NativeThread.HIGH_PRIORITY);
        } else {
            server.getCore().getExecutor().execute(new PrioRunnable(){

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }

                @Override
                public void run() {
                    try {
                        ClientRequest.this.restart(server.getCore().getClientContext(), disableFilterData);
                    }
                    catch (PersistenceDisabledException persistenceDisabledException) {
                        // empty catch block
                    }
                }
            }, "Restart request");
        }
    }

    public void requestWasRemoved(ClientContext context) {
        if (this.persistence != Persistence.FOREVER) {
            return;
        }
    }

    protected boolean isGlobalQueue() {
        if (this.client == null) {
            return false;
        }
        return this.client.isGlobalQueue;
    }

    public PersistentRequestClient getClient() {
        return this.client;
    }

    abstract RequestStatus getStatus();

    public void getClientDetail(DataOutputStream dos, ChecksumChecker checker) throws IOException {
        if (this.persistence != Persistence.FOREVER) {
            return;
        }
        dos.writeLong(-1445456516116158687L);
        dos.writeInt(1);
        RequestIdentifier req = this.getRequestIdentifier();
        req.writeTo(dos);
        dos.writeBoolean(this.realTime);
        dos.writeInt(this.verbosity);
        dos.writeLong(this.startupTime);
        dos.writeShort(this.priorityClass);
        if (this.clientToken == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.clientToken);
        }
        dos.writeBoolean(this.finished);
    }

    protected ClientRequest(DataInputStream dis, RequestIdentifier reqID, ClientContext context) throws IOException, StorageFormatException {
        long magic = dis.readLong();
        if (magic != -1445456516116158687L) {
            throw new StorageFormatException("Bad magic");
        }
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        RequestIdentifier copyReq = new RequestIdentifier(dis);
        if (!copyReq.equals(reqID)) {
            throw new StorageFormatException("Request identifier has changed");
        }
        this.realTime = dis.readBoolean();
        this.verbosity = dis.readInt();
        this.startupTime = dis.readLong();
        this.priorityClass = dis.readShort();
        if (this.priorityClass < 0 || this.priorityClass > 6) {
            throw new StorageFormatException("Bogus priority");
        }
        this.clientToken = dis.readBoolean() ? dis.readUTF() : null;
        this.finished = dis.readBoolean();
        this.persistence = Persistence.FOREVER;
        this.origHandler = null;
        this.identifier = reqID.identifier;
        this.global = reqID.globalQueue;
        this.clientName = reqID.clientName;
        this.hashCode = super.hashCode();
        this.client = context.persistentRoot.makeClient(this.global, this.clientName);
        this.lowLevelClient = this.client.lowLevelClient(this.realTime);
    }

    public final void onResume(ClientContext context) throws ResumeFailedException {
        this.client = context.persistentRoot.makeClient(this.global, this.clientName);
        this.lowLevelClient = this.client.lowLevelClient(this.realTime);
        this.innerResume(context);
        ClientRequester req = this.getClientRequest();
        if (req != null) {
            req.onResume(context);
        }
        context.persistentRoot.resume(this, this.global, this.clientName);
    }

    protected abstract void innerResume(ClientContext var1) throws ResumeFailedException;

    public RequestClient getRequestClient() {
        return this.lowLevelClient;
    }

    public RequestIdentifier getRequestIdentifier() {
        if (this.persistence == Persistence.CONNECTION) {
            throw new IllegalStateException();
        }
        return new RequestIdentifier(this.global, this.clientName, this.identifier, this.getType());
    }

    abstract RequestIdentifier.RequestType getType();

    public static ClientRequest restartFrom(DataInputStream dis, RequestIdentifier reqID, ClientContext context, ChecksumChecker checker) throws StorageFormatException, IOException, ResumeFailedException {
        switch (reqID.type) {
            case GET: {
                return ClientGet.restartFrom(dis, reqID, context, checker);
            }
        }
        return null;
    }

    public abstract boolean fullyResumed();

    public void onShutdown(ClientContext context) {
        ClientRequester request = this.getClientRequest();
        if (request != null) {
            request.onShutdown(context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static enum Persistence {
        CONNECTION,
        REBOOT,
        FOREVER;


        public static Persistence parseOrThrow(String persistenceString, String identifier, boolean global) throws MessageInvalidException {
            try {
                if (persistenceString == null) {
                    return CONNECTION;
                }
                return Persistence.valueOf(persistenceString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new MessageInvalidException(6, "Error parsing Persistence field: " + persistenceString, identifier, global);
            }
        }

        @Deprecated
        public static Persistence getByCode(short persistenceType) {
            if (persistenceType < 0 || persistenceType > Persistence.values().length) {
                throw new IllegalArgumentException();
            }
            return Persistence.values()[persistenceType];
        }
    }
}

