/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class OggPage {
    boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    static final byte[] magicNumber = new byte[]{79, 103, 103, 83};
    private static final int[] crc_lookup = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
    final byte version;
    final byte headerType;
    final byte[] granuelPosition;
    final byte[] bitStreamSerial;
    final byte[] pageSequenceNumber;
    byte[] checksum = new byte[4];
    byte segments;
    byte[] segmentTable;
    byte[] payload;

    public OggPage(DataInputStream input) throws IOException {
        this.version = input.readByte();
        Logger.minor(this, "Version: " + this.version);
        this.headerType = input.readByte();
        Logger.minor(this, "Headertype: " + this.headerType);
        this.granuelPosition = new byte[8];
        this.bitStreamSerial = new byte[4];
        this.pageSequenceNumber = new byte[4];
        input.readFully(this.granuelPosition);
        input.readFully(this.bitStreamSerial);
        input.readFully(this.pageSequenceNumber);
        input.readFully(this.checksum);
        Logger.minor(this, "Checksum: " + Integer.toHexString(OggPage.byteToUnsigned(this.checksum[0])) + Integer.toHexString(OggPage.byteToUnsigned(this.checksum[1])) + Integer.toHexString(OggPage.byteToUnsigned(this.checksum[2])) + Integer.toHexString(OggPage.byteToUnsigned(this.checksum[3])));
        this.segments = OggPage.intToUnsignedByte(input.readUnsignedByte());
        this.segmentTable = new byte[OggPage.byteToUnsigned(this.segments)];
        input.readFully(this.segmentTable);
        int payloadSize = 0;
        for (int i = 0; i < OggPage.byteToUnsigned(this.segments); ++i) {
            payloadSize += OggPage.byteToUnsigned(this.segmentTable[i]);
        }
        this.payload = new byte[payloadSize];
        input.readFully(this.payload);
        Logger.minor(this, "Created page with " + this.segments + " segments");
    }

    public OggPage(OggPage oldPage, Collection<CodecPacket> packets) throws IOException {
        this.version = oldPage.version;
        this.headerType = oldPage.headerType;
        Logger.minor(this, "Header type: " + Integer.toBinaryString(this.headerType));
        this.granuelPosition = oldPage.granuelPosition;
        this.bitStreamSerial = oldPage.bitStreamSerial;
        this.pageSequenceNumber = oldPage.pageSequenceNumber;
        this.segments = 0;
        ArrayList<Byte> segmentSizes = new ArrayList<Byte>();
        ByteArrayOutputStream payloadStream = new ByteArrayOutputStream();
        for (CodecPacket packet : packets) {
            int wholeSegments = packet.payload.length / 255;
            int concludingPartialSegment = packet.payload.length % 255;
            Logger.minor(this, "Whole segments: " + wholeSegments + " Partial: " + concludingPartialSegment);
            for (int i = 0; i < wholeSegments; ++i) {
                segmentSizes.add(OggPage.intToUnsignedByte(255));
            }
            if (concludingPartialSegment != 0) {
                segmentSizes.add(OggPage.intToUnsignedByte(concludingPartialSegment));
            }
            Logger.minor(this, "Writing packet sized: " + packet.payload.length);
            payloadStream.write(packet.payload);
        }
        this.segments = OggPage.intToUnsignedByte(segmentSizes.size());
        this.segmentTable = new byte[OggPage.byteToUnsigned(this.segments)];
        Logger.minor(this, "SegmentSizes len: " + segmentSizes.size() + " SegmentTable size: " + this.segmentTable.length + " Segments: " + this.segments);
        for (int i = 0; i < segmentSizes.size(); ++i) {
            this.segmentTable[i] = (Byte)segmentSizes.get(i);
        }
        payloadStream.close();
        this.payload = payloadStream.toByteArray();
        Logger.minor(this, "Payload size: " + this.payload.length + "Made of " + packets.size() + " packets");
        this.checksum = this.calculateCRC();
    }

    public static void seekToPage(DataInputStream input) throws IOException {
        while (input.readByte() != magicNumber[0] || input.readByte() != magicNumber[1] || input.readByte() != magicNumber[2] || input.readByte() != magicNumber[3]) {
        }
    }

    public static OggPage readPage(DataInputStream input) throws IOException {
        OggPage.seekToPage(input);
        return new OggPage(input);
    }

    public boolean headerValid() {
        if (this.version != 0) {
            return false;
        }
        return Arrays.equals(this.checksum, this.calculateCRC());
    }

    public boolean isPacketContinued() {
        if (this.logMINOR) {
            Logger.minor(this, "Packet continued: " + (this.headerType & 1));
        }
        return (this.headerType & 1) == 1;
    }

    public boolean isFinalPacket() {
        return (this.headerType & 4) == 4;
    }

    public byte[] toArray() {
        ByteBuffer bb = ByteBuffer.allocate(27 + OggPage.byteToUnsigned(this.segments) + this.payload.length);
        bb.put(magicNumber);
        bb.put(this.version);
        bb.put(this.headerType);
        bb.put(this.granuelPosition);
        bb.put(this.bitStreamSerial);
        bb.put(this.pageSequenceNumber);
        bb.put(this.checksum);
        bb.put(this.segments);
        bb.put(this.segmentTable);
        bb.put(this.payload);
        return bb.array();
    }

    public int getSerial() {
        ByteBuffer bb = ByteBuffer.wrap(this.bitStreamSerial);
        return bb.getInt();
    }

    public int getPageNumber() {
        ByteBuffer bb = ByteBuffer.wrap(this.pageSequenceNumber);
        return Integer.reverseBytes(bb.getInt());
    }

    public byte[] calculateCRC() {
        byte[] array = this.toArray();
        array[22] = 0;
        array[23] = 0;
        array[24] = 0;
        array[25] = 0;
        int crc_reg = 0;
        for (int i = 0; i < array.length; ++i) {
            crc_reg = crc_reg << 8 ^ crc_lookup[crc_reg >>> 24 & 0xFF ^ array[i] & 0xFF];
        }
        return new byte[]{(byte)crc_reg, (byte)(crc_reg >>> 8), (byte)(crc_reg >>> 16), (byte)(crc_reg >>> 24)};
    }

    public void recalculateSegmentLacing(LinkedList<Integer> packetSizes) {
        if (packetSizes == null) {
            packetSizes = new LinkedList();
            packetSizes.push(this.payload.length);
        }
        this.segments = 0;
        Iterator iterator = packetSizes.iterator();
        while (iterator.hasNext()) {
            int packet = (Integer)iterator.next();
            this.segments = (byte)(this.segments + (packet / 255 + (packet % 255 == 0 ? 0 : 1)));
            if (!this.logMINOR) continue;
            Logger.minor(this, "Size of current packet: " + packet + " Current number of segments: " + this.segments + " Number of whole segments belonging to this packet: " + packet / 255 + " Remaining bytes " + packet % 255);
        }
        if (this.logMINOR) {
            Logger.minor(this, "Segments " + this.segments);
        }
        this.segmentTable = new byte[this.segments];
        int segment = 0;
        Iterator iterator2 = packetSizes.iterator();
        while (iterator2.hasNext()) {
            int packet = (Integer)iterator2.next();
            if (this.logMINOR) {
                Logger.minor(this, "Setting segments for packet sized " + packet);
            }
            for (int packetSegment = 0; packetSegment < packet / 255; ++packetSegment) {
                if (this.logMINOR) {
                    Logger.minor(this, "Setting segment " + segment + " to full.");
                }
                this.segmentTable[segment] = OggPage.intToUnsignedByte(255);
                ++segment;
            }
            int remainder = packet % 255;
            if (remainder == 0) continue;
            if (this.logMINOR) {
                Logger.minor(this, "Partially filling segment " + segment);
            }
            this.segmentTable[segment] = OggPage.intToUnsignedByte(remainder);
            ++segment;
        }
    }

    public Collection<CodecPacket> asPackets() {
        Logger.minor(this, "Creating packets for " + OggPage.byteToUnsigned(this.segments) + " segments");
        ArrayList<CodecPacket> packets = new ArrayList<CodecPacket>();
        int bytesParsed = 0;
        int packetSize = 0;
        for (int i = 0; i < this.segmentTable.length; ++i) {
            if (OggPage.byteToUnsigned(this.segmentTable[i]) % 255 != 0 || OggPage.byteToUnsigned(this.segmentTable[i]) == 0 || i == this.segmentTable.length - 1) {
                byte[] packetPayload = new byte[packetSize += OggPage.byteToUnsigned(this.segmentTable[i])];
                try {
                    System.arraycopy(this.payload, bytesParsed, packetPayload, 0, packetSize);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Logger.error(this, "Error, Out of Bounds.Page sequence number: " + OggPage.byteToUnsigned(this.pageSequenceNumber[0]) + " " + OggPage.byteToUnsigned(this.pageSequenceNumber[1]) + " " + OggPage.byteToUnsigned(this.pageSequenceNumber[2]) + " " + OggPage.byteToUnsigned(this.pageSequenceNumber[3]) + " bytesParsed: " + bytesParsed + " packetSize: " + packetSize + " Payload length: " + this.payload.length, (Throwable)e);
                    throw e;
                }
                bytesParsed += packetSize;
                packets.add(new CodecPacket(packetPayload));
                packetSize = 0;
                continue;
            }
            packetSize += 255;
        }
        return packets;
    }

    private static int byteToUnsigned(byte input) {
        return input & 0xFF;
    }

    private static byte intToUnsignedByte(int input) {
        return (byte)(input & 0xFF);
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("OggPage." + key);
    }
}

