/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.FetchException;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLEncoder;
import java.util.LinkedList;
import java.util.List;

public class KnownUnsafeContentTypeException
extends UnsafeContentTypeException {
    private static final long serialVersionUID = -1L;
    FilterMIMEType type;

    public KnownUnsafeContentTypeException(FilterMIMEType type) {
        this.type = type;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(KnownUnsafeContentTypeException.l10n("knownUnsafe"));
        sb.append(KnownUnsafeContentTypeException.l10n("noFilter"));
        return sb.toString();
    }

    @Override
    public List<String> details() {
        LinkedList<String> details = new LinkedList<String>();
        if (this.type.dangerousInlines) {
            details.add(KnownUnsafeContentTypeException.l10n("dangerousInlinesLabel") + KnownUnsafeContentTypeException.l10n("dangerousInlines"));
        }
        if (this.type.dangerousLinks) {
            details.add(KnownUnsafeContentTypeException.l10n("dangerousLinksLabel") + KnownUnsafeContentTypeException.l10n("dangerousLinks"));
        }
        if (this.type.dangerousScripting) {
            details.add(KnownUnsafeContentTypeException.l10n("dangerousScriptsLabel") + KnownUnsafeContentTypeException.l10n("dangerousScripts"));
        }
        if (this.type.dangerousScripting) {
            details.add(KnownUnsafeContentTypeException.l10n("dangerousMetadataLabel") + KnownUnsafeContentTypeException.l10n("dangerousMetadata"));
        }
        return details;
    }

    @Override
    public String getHTMLEncodedTitle() {
        return KnownUnsafeContentTypeException.l10n("title", "type", HTMLEncoder.encode(this.type.primaryMimeType));
    }

    @Override
    public String getRawTitle() {
        return KnownUnsafeContentTypeException.l10n("title", "type", this.type.primaryMimeType);
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("KnownUnsafeContentTypeException." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("KnownUnsafeContentTypeException." + key, pattern, value);
    }

    @Override
    public FetchException.FetchExceptionMode getFetchErrorCode() {
        return FetchException.FetchExceptionMode.CONTENT_VALIDATION_BAD_MIME;
    }
}

