/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.CompressionOutput;
import freenet.client.async.InsertCompressor;
import freenet.client.async.MultiPutCompletionCallback;
import freenet.client.async.PersistentJob;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.client.async.SplitFileInserter;
import freenet.client.async.USKInserter;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.FinishedCompressionEvent;
import freenet.client.events.StartedCompressionEvent;
import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.crypt.MultiHashOutputStream;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import freenet.support.io.NotPersistentBucket;
import freenet.support.io.NullOutputStream;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;

class SingleFileInserter
implements ClientPutState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final BaseClientPutter parent;
    InsertBlock block;
    final InsertContext ctx;
    final boolean metadata;
    final PutCompletionCallback cb;
    final ArchiveManager.ARCHIVE_TYPE archiveType;
    private final boolean reportMetadataOnly;
    public final Object token;
    private final boolean freeData;
    private final String targetFilename;
    private final boolean persistent;
    private boolean started;
    private boolean cancelled;
    private final boolean forSplitfile;
    private final long origDataLength;
    private final long origCompressedDataLength;
    private HashResult[] origHashes;
    private final byte[] forceCryptoKey;
    private final byte cryptoAlgorithm;
    private final boolean realTimeFlag;
    private final long metadataThreshold;
    private final int hashCode = super.hashCode();
    private transient boolean resumed = false;

    public int hashCode() {
        return this.hashCode;
    }

    SingleFileInserter(BaseClientPutter parent, PutCompletionCallback cb, InsertBlock block, boolean metadata, InsertContext ctx, boolean realTimeFlag, boolean dontCompress, boolean reportMetadataOnly, Object token, ArchiveManager.ARCHIVE_TYPE archiveType, boolean freeData, String targetFilename, boolean forSplitfile, boolean persistent, long origDataLength, long origCompressedDataLength, HashResult[] origHashes, byte cryptoAlgorithm, byte[] forceCryptoKey, long metadataThreshold) {
        this.reportMetadataOnly = reportMetadataOnly;
        this.token = token;
        this.parent = parent;
        this.block = block;
        this.ctx = ctx;
        this.realTimeFlag = realTimeFlag;
        this.metadata = metadata;
        this.cb = cb;
        this.archiveType = archiveType;
        this.freeData = freeData;
        this.targetFilename = targetFilename;
        this.persistent = persistent;
        this.forSplitfile = forSplitfile;
        this.origCompressedDataLength = origCompressedDataLength;
        this.origDataLength = origDataLength;
        this.origHashes = origHashes;
        this.forceCryptoKey = forceCryptoKey;
        this.cryptoAlgorithm = cryptoAlgorithm;
        this.metadataThreshold = metadataThreshold;
        if (logMINOR) {
            Logger.minor(this, "Created " + this + " persistent=" + persistent + " freeData=" + freeData);
        }
    }

    public void start(ClientContext context) throws InsertException {
        this.tryCompress(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCompressed(CompressionOutput output, ClientContext context) {
        SingleFileInserter singleFileInserter = this;
        synchronized (singleFileInserter) {
            if (this.started) {
                Logger.error(this, "Already started, not starting again", (Throwable)new Exception("error"));
                return;
            }
            if (this.cancelled) {
                Logger.error(this, "Already cancelled, not starting");
                return;
            }
        }
        try {
            this.onCompressedInner(output, context);
        }
        catch (InsertException e) {
            this.cb.onFailure(e, this, context);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught in OffThreadCompressor: " + t, t);
            System.err.println("Caught in OffThreadCompressor: " + t);
            t.printStackTrace();
            this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, t, null), this, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCompressedInner(CompressionOutput output, ClientContext context) throws InsertException {
        boolean allowSizes;
        LockableRandomAccessBuffer dataRAF;
        boolean noMetadata;
        boolean fitsInOneCHK;
        boolean fitsInOneBlockAsIs;
        int oneBlockCompressedSize;
        int blockSize;
        HashResult[] hashes = output.hashes;
        long origSize = this.block.getData().size();
        byte[] hashThisLayerOnly = null;
        if (hashes != null && this.metadata) {
            hashThisLayerOnly = HashResult.get(hashes, HashType.SHA256);
            hashes = null;
        }
        if (hashes != null) {
            if (logDEBUG) {
                Logger.debug(this, "Computed hashes for " + this + " for " + this.block.desiredURI + " size " + origSize);
                for (HashResult res : hashes) {
                    Logger.debug(this, res.type.name() + " : " + res.hashAsHex());
                }
            }
            HashResult[] clientHashes = hashes;
            if (this.persistent) {
                clientHashes = HashResult.copy(hashes);
            }
            this.ctx.eventProducer.produceEvent(new ExpectedHashesEvent(clientHashes), context);
            this.origHashes = hashes;
        } else {
            hashes = this.origHashes;
        }
        RandomAccessBucket bestCompressedData = output.data;
        long bestCompressedDataSize = bestCompressedData.size();
        RandomAccessBucket data = bestCompressedData;
        Compressor.COMPRESSOR_TYPE bestCodec = output.bestCodec;
        boolean shouldFreeData = this.freeData;
        if (bestCodec != null) {
            if (logMINOR) {
                Logger.minor(this, "The best compression algorithm is " + bestCodec + " we have gained" + (100L - bestCompressedDataSize * 100L / origSize) + "% ! (" + origSize + '/' + bestCompressedDataSize + ')');
            }
            shouldFreeData = true;
            if (this.freeData) {
                this.block.getData().free();
            }
            this.block.nullData();
        } else {
            data = this.block.getData();
            bestCompressedDataSize = origSize;
        }
        boolean isCHK = false;
        String type = this.block.desiredURI.getKeyType();
        boolean isUSK = false;
        if (type.equals("SSK") || type.equals("KSK") || (isUSK = type.equals("USK"))) {
            blockSize = 1024;
            oneBlockCompressedSize = 1022;
        } else if (type.equals("CHK")) {
            blockSize = 32768;
            oneBlockCompressedSize = 32764;
            isCHK = true;
        } else {
            throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, "Unknown key type: " + type, null);
        }
        if (this.parent == this.cb) {
            int codecID = bestCodec == null ? -1 : (int)bestCodec.metadataID;
            this.ctx.eventProducer.produceEvent(new FinishedCompressionEvent(codecID, origSize, bestCompressedDataSize), context);
            if (logMINOR) {
                Logger.minor(this, "Compressed " + origSize + " to " + data.size() + " on " + this + " data = " + data);
            }
        }
        short codecNumber = bestCodec == null ? (short)-1 : (short)bestCodec.metadataID;
        long compressedDataSize = data.size();
        boolean bl = bestCodec == null ? compressedDataSize <= (long)blockSize : (fitsInOneBlockAsIs = compressedDataSize <= (long)oneBlockCompressedSize);
        boolean bl2 = bestCodec == null ? compressedDataSize <= 32768L : (fitsInOneCHK = compressedDataSize <= 32764L);
        if ((fitsInOneBlockAsIs || fitsInOneCHK) && origSize > Integer.MAX_VALUE) {
            throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "2GB+ should not encode to one block!", null);
        }
        boolean bl3 = noMetadata = (this.block.clientMetadata == null || this.block.clientMetadata.isTrivial()) && this.targetFilename == null;
        if ((noMetadata || this.metadata) && this.archiveType == null && fitsInOneBlockAsIs) {
            if (this.persistent && data instanceof NotPersistentBucket) {
                data = this.fixNotPersistent(data, context);
            }
            ClientPutState bi = this.createInserter(this.parent, data, codecNumber, this.ctx, this.cb, this.metadata, (int)origSize, -1, true, context, shouldFreeData, this.forSplitfile);
            if (logMINOR) {
                Logger.minor(this, "Inserting without metadata: " + bi + " for " + this);
            }
            this.cb.onTransition(this, bi, context);
            if (this.ctx.earlyEncode && bi instanceof SingleBlockInserter && isCHK) {
                ((SingleBlockInserter)bi).getBlock(context, true);
            }
            bi.schedule(context);
            if (!isUSK) {
                this.cb.onBlockSetFinished(this, context);
            }
            SingleFileInserter singleFileInserter = this;
            synchronized (singleFileInserter) {
                this.started = true;
            }
            if (this.persistent) {
                this.block.nullData();
                this.block = null;
            }
            return;
        }
        if (fitsInOneCHK) {
            RandomAccessBucket metadataBucket;
            if (this.persistent && data instanceof NotPersistentBucket) {
                data = this.fixNotPersistent(data, context);
            }
            if (this.reportMetadataOnly) {
                SingleBlockInserter dataPutter = new SingleBlockInserter(this.parent, data, codecNumber, FreenetURI.EMPTY_CHK_URI, this.ctx, this.realTimeFlag, this.cb, this.metadata, (int)origSize, -1, true, true, this.token, context, this.persistent, shouldFreeData, this.forSplitfile ? this.ctx.extraInsertsSplitfileHeaderBlock : this.ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
                if (logMINOR) {
                    Logger.minor(this, "Inserting with metadata: " + dataPutter + " for " + this);
                }
                Metadata meta = this.makeMetadata(this.archiveType, dataPutter.getURI(context), hashes);
                this.cb.onMetadata(meta, (ClientPutState)this, context);
                this.cb.onTransition(this, dataPutter, context);
                dataPutter.schedule(context);
                if (!isUSK) {
                    this.cb.onBlockSetFinished(this, context);
                }
                SingleFileInserter singleFileInserter = this;
                synchronized (singleFileInserter) {
                    this.origHashes = null;
                }
            }
            ClientPutState mcb = new MultiPutCompletionCallback(this.cb, this.parent, this.token, this.persistent, false, this.ctx.earlyEncode);
            SingleBlockInserter dataPutter = new SingleBlockInserter(this.parent, data, codecNumber, FreenetURI.EMPTY_CHK_URI, this.ctx, this.realTimeFlag, (PutCompletionCallback)((Object)mcb), this.metadata, (int)origSize, -1, true, false, this.token, context, this.persistent, shouldFreeData, this.forSplitfile ? this.ctx.extraInsertsSplitfileHeaderBlock : this.ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
            if (logMINOR) {
                Logger.minor(this, "Inserting data: " + dataPutter + " for " + this);
            }
            Metadata meta = this.makeMetadata(this.archiveType, dataPutter.getURI(context), hashes);
            try {
                metadataBucket = meta.toBucket(context.getBucketFactory(this.persistent));
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
            }
            catch (MetadataUnresolvedException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "Got MetadataUnresolvedException in SingleFileInserter: " + e.toString(), null);
            }
            ClientPutState metaPutter = this.createInserter(this.parent, metadataBucket, (short)-1, this.ctx, (PutCompletionCallback)((Object)mcb), true, (int)origSize, -1, true, context, true, false);
            if (logMINOR) {
                Logger.minor(this, "Inserting metadata: " + metaPutter + " for " + this);
            }
            ((MultiPutCompletionCallback)mcb).addURIGenerator(metaPutter);
            ((MultiPutCompletionCallback)mcb).add(dataPutter);
            this.cb.onTransition(this, mcb, context);
            Logger.minor(this, "" + mcb + " : data " + dataPutter + " meta " + metaPutter);
            ((MultiPutCompletionCallback)mcb).arm(context);
            dataPutter.schedule(context);
            if (this.ctx.earlyEncode && metaPutter instanceof SingleBlockInserter) {
                ((SingleBlockInserter)metaPutter).getBlock(context, true);
            }
            metaPutter.schedule(context);
            if (!isUSK) {
                this.cb.onBlockSetFinished(this, context);
            }
            mcb = this;
            synchronized (mcb) {
                this.started = true;
            }
            if (this.persistent) {
                this.block.nullData();
                this.block = null;
            }
            return;
        }
        try {
            dataRAF = data.toRandomAccessBuffer();
        }
        catch (IOException e) {
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        if (this.reportMetadataOnly) {
            SplitFileInserter sfi = new SplitFileInserter(this.persistent, this.parent, this.cb, dataRAF, shouldFreeData, this.ctx, context, origSize, bestCodec, this.block.clientMetadata, this.metadata, this.archiveType, this.cryptoAlgorithm, this.forceCryptoKey, hashThisLayerOnly, hashes, this.ctx.dontCompress, this.parent.getMinSuccessFetchBlocks(), this.parent.getTotalBlocks(), this.origDataLength, this.origCompressedDataLength, this.realTimeFlag, this.token);
            if (logMINOR) {
                Logger.minor(this, "Inserting as splitfile: " + sfi + " for " + this);
            }
            this.cb.onTransition(this, sfi, context);
            sfi.schedule(context);
            this.block.nullData();
            this.block.nullMetadata();
            SingleFileInserter meta = this;
            synchronized (meta) {
                this.origHashes = null;
            }
        }
        InsertContext.CompatibilityMode cmode = this.ctx.getCompatibilityMode();
        boolean bl4 = allowSizes = cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
        if (this.metadata) {
            allowSizes = false;
        }
        SplitHandler sh = new SplitHandler(origSize, compressedDataSize, allowSizes);
        SplitFileInserter sfi = new SplitFileInserter(this.persistent, this.parent, sh, dataRAF, shouldFreeData, this.ctx, context, origSize, bestCodec, this.block.clientMetadata, this.metadata, this.archiveType, this.cryptoAlgorithm, this.forceCryptoKey, hashThisLayerOnly, hashes, this.ctx.dontCompress, this.parent.getMinSuccessFetchBlocks(), this.parent.getTotalBlocks(), this.origDataLength, this.origCompressedDataLength, this.realTimeFlag, this.token);
        sh.sfi = sfi;
        if (logMINOR) {
            Logger.minor(this, "Inserting as splitfile: " + sfi + " for " + sh + " for " + this);
        }
        this.cb.onTransition(this, sh, context);
        sfi.schedule(context);
        SingleFileInserter singleFileInserter = this;
        synchronized (singleFileInserter) {
            this.started = true;
        }
    }

    private RandomAccessBucket fixNotPersistent(RandomAccessBucket data, ClientContext context) throws InsertException {
        boolean skip = false;
        try {
            if (!skip) {
                if (logMINOR) {
                    Logger.minor(this, "Copying data from " + data + " length " + data.size());
                }
                RandomAccessBucket newData = context.persistentBucketFactory.makeBucket(data.size());
                BucketTools.copy(data, newData);
                data.free();
                data = newData;
            }
        }
        catch (IOException e) {
            Logger.error(this, "Caught " + e + " while copying non-persistent data", (Throwable)e);
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        return data;
    }

    private void tryCompress(ClientContext context) throws InsertException {
        boolean tryCompress;
        boolean atLeast1254;
        int oneBlockCompressedSize;
        int blockSize;
        RandomAccessBucket origData;
        RandomAccessBucket data = origData = this.block.getData();
        boolean dontCompress = this.ctx.dontCompress;
        long origSize = data.size();
        String type = this.block.desiredURI.getKeyType().toUpperCase();
        if (type.equals("SSK") || type.equals("KSK") || type.equals("USK")) {
            blockSize = 1024;
            oneBlockCompressedSize = 1022;
        } else if (type.equals("CHK")) {
            blockSize = 32768;
            oneBlockCompressedSize = 32764;
        } else {
            throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, "Unknown key type: " + type, null);
        }
        long wantHashes = 0L;
        InsertContext.CompatibilityMode cmode = this.ctx.getCompatibilityMode();
        boolean bl = atLeast1254 = cmode == InsertContext.CompatibilityMode.COMPAT_CURRENT || cmode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1255.ordinal();
        if (atLeast1254) {
            wantHashes |= (long)HashType.SHA256.bitmask;
            if (data.size() >= 0x100000L && !this.metadata) {
                wantHashes |= (long)HashType.SHA1.bitmask;
                wantHashes |= (long)HashType.MD5.bitmask;
            }
            if (data.size() >= 0x400000L && !this.metadata) {
                wantHashes |= (long)HashType.ED2K.bitmask;
                wantHashes |= (long)HashType.TTH.bitmask;
                wantHashes |= (long)HashType.SHA512.bitmask;
            }
        }
        boolean bl2 = tryCompress = origSize > (long)blockSize && !this.ctx.dontCompress && !dontCompress;
        if (tryCompress) {
            InsertCompressor.start(context, this, origData, oneBlockCompressedSize, context.getBucketFactory(this.persistent), this.persistent, wantHashes, !atLeast1254, context.getConfig());
        } else {
            if (logMINOR) {
                Logger.minor(this, "Not compressing " + origData + " size = " + origSize + " block size = " + blockSize);
            }
            HashResult[] hashes = null;
            if (wantHashes != 0L) {
                NullOutputStream nos = new NullOutputStream();
                MultiHashOutputStream hasher = new MultiHashOutputStream(nos, wantHashes);
                try {
                    BucketTools.copyTo(data, hasher, data.size());
                }
                catch (IOException e) {
                    throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, "I/O error generating hashes", e, null);
                }
                hashes = hasher.getResults();
            }
            final CompressionOutput output = new CompressionOutput(data, null, hashes);
            context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    SingleFileInserter.this.onCompressed(output, context);
                    return true;
                }
            });
        }
    }

    private Metadata makeMetadata(ArchiveManager.ARCHIVE_TYPE archiveType, FreenetURI uri, HashResult[] hashes) {
        Metadata meta = null;
        boolean allowTopBlocks = this.origDataLength != 0L;
        int req = 0;
        int total = 0;
        long data = 0L;
        long compressed = 0L;
        boolean topDontCompress = false;
        InsertContext.CompatibilityMode topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        if (allowTopBlocks) {
            req = this.parent.getMinSuccessFetchBlocks();
            total = this.parent.totalBlocks;
            topDontCompress = this.ctx.dontCompress;
            topCompatibilityMode = this.ctx.getCompatibilityMode();
            data = this.origDataLength;
            compressed = this.origCompressedDataLength;
        }
        meta = archiveType != null ? new Metadata(Metadata.DocumentType.ARCHIVE_MANIFEST, archiveType, null, uri, this.block.clientMetadata, data, compressed, req, total, topDontCompress, topCompatibilityMode, hashes) : new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, archiveType, null, uri, this.block.clientMetadata, data, compressed, req, total, topDontCompress, topCompatibilityMode, hashes);
        if (this.targetFilename != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put(this.targetFilename, meta);
            meta = Metadata.mkRedirectionManifestWithMetadata(hm);
        }
        return meta;
    }

    private ClientPutState createInserter(BaseClientPutter parent, Bucket data, short compressionCodec, InsertContext ctx, PutCompletionCallback cb, boolean isMetadata, int sourceLength, int token, boolean addToParent, ClientContext context, boolean freeData, boolean forSplitfile) throws InsertException {
        FreenetURI uri = this.block.desiredURI;
        uri.checkInsertURI();
        if (uri.getKeyType().equals("USK")) {
            try {
                return new USKInserter(parent, data, compressionCodec, uri, ctx, cb, isMetadata, sourceLength, token, addToParent, this.token, context, freeData, this.persistent, this.realTimeFlag, forSplitfile ? ctx.extraInsertsSplitfileHeaderBlock : ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
            }
            catch (MalformedURLException e) {
                throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, e, null);
            }
        }
        SingleBlockInserter sbi = new SingleBlockInserter(parent, data, compressionCodec, uri, ctx, this.realTimeFlag, cb, isMetadata, sourceLength, token, addToParent, false, this.token, context, this.persistent, freeData, forSplitfile ? ctx.extraInsertsSplitfileHeaderBlock : ctx.extraInsertsSingleBlock, this.cryptoAlgorithm, this.forceCryptoKey);
        this.block.nullURI();
        return sbi;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancel " + this);
        }
        SingleFileInserter singleFileInserter = this;
        synchronized (singleFileInserter) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        if (this.freeData) {
            this.block.free();
        }
        this.cb.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), this, context);
    }

    @Override
    public void schedule(ClientContext context) throws InsertException {
        this.start(context);
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    public void onStartCompression(Compressor.COMPRESSOR_TYPE ctype, ClientContext context) {
        if (this.parent == this.cb) {
            if (this.ctx == null) {
                throw new NullPointerException();
            }
            if (this.ctx.eventProducer == null) {
                throw new NullPointerException();
            }
            this.ctx.eventProducer.produceEvent(new StartedCompressionEvent(ctype), context);
        }
    }

    synchronized boolean cancelled() {
        return this.cancelled;
    }

    synchronized boolean started() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        SingleFileInserter singleFileInserter = this;
        synchronized (singleFileInserter) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        if (this.block != null && this.block.getData() != null) {
            this.block.getData().onResume(context);
        }
        if (this.cb != null && this.cb != this.parent) {
            this.cb.onResume(context);
        }
        singleFileInserter = this;
        synchronized (singleFileInserter) {
            if (this.started || this.cancelled) {
                return;
            }
        }
        this.tryCompress(context);
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    static /* synthetic */ HashResult[] access$802(SingleFileInserter x0, HashResult[] x1) {
        x0.origHashes = x1;
        return x1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public class SplitHandler
    implements PutCompletionCallback,
    ClientPutState,
    Serializable {
        private static final long serialVersionUID = 1L;
        ClientPutState sfi;
        ClientPutState metadataPutter;
        boolean finished;
        boolean splitInsertSuccess;
        boolean metaInsertSuccess;
        boolean splitInsertSetBlocks;
        boolean metaInsertSetBlocks;
        boolean metaInsertStarted;
        boolean metaFetchable;
        final boolean persistent;
        final long origDataLength;
        final long origCompressedDataLength;
        private transient boolean resumed;
        private final int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public SplitHandler(long origDataLength, long origCompressedDataLength, boolean allowSizes) {
            this.persistent = SingleFileInserter.this.persistent;
            this.hashCode = super.hashCode();
            this.origDataLength = allowSizes ? origDataLength : 0L;
            this.origCompressedDataLength = allowSizes ? origCompressedDataLength : 0L;
        }

        @Override
        public synchronized void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "Transition: " + oldState + " -> " + newState);
            }
            if (oldState == this.sfi) {
                this.sfi = newState;
            }
            if (oldState == this.metadataPutter) {
                this.metadataPutter = newState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onSuccess(" + state + ") for " + this);
            }
            boolean lateStart = false;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (state == this.sfi) {
                    if (logMINOR) {
                        Logger.minor(this, "Splitfile insert succeeded for " + this + " : " + state);
                    }
                    this.splitInsertSuccess = true;
                    if (!this.metaInsertSuccess && !this.metaInsertStarted) {
                        lateStart = true;
                    } else {
                        this.sfi = null;
                        if (logMINOR) {
                            Logger.minor(this, "Metadata already started for " + this + " : success=" + this.metaInsertSuccess + " started=" + this.metaInsertStarted);
                        }
                    }
                } else if (state == this.metadataPutter) {
                    if (logMINOR) {
                        Logger.minor(this, "Metadata insert succeeded for " + this + " : " + state);
                    }
                    this.metaInsertSuccess = true;
                    this.metadataPutter = null;
                } else {
                    Logger.error(this, "Unknown: " + state + " for " + this, (Throwable)new Exception("debug"));
                }
                if (this.splitInsertSuccess && this.metaInsertSuccess) {
                    if (logMINOR) {
                        Logger.minor(this, "Both succeeded for " + this);
                    }
                    this.finished = true;
                    if (SingleFileInserter.this.freeData) {
                        SingleFileInserter.this.block.free();
                    } else {
                        SingleFileInserter.this.block.nullData();
                    }
                }
            }
            if (lateStart && this.startMetadata(context)) {
                splitHandler = this;
                synchronized (splitHandler) {
                    this.sfi = null;
                }
            }
            if (this.finished) {
                SingleFileInserter.this.cb.onSuccess(this, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
            boolean toFail = true;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (logMINOR) {
                    Logger.minor(this, "onFailure(): " + e + " on " + state + " on " + this + " sfi = " + this.sfi + " metadataPutter = " + this.metadataPutter);
                }
                if (state == this.sfi) {
                    this.sfi = null;
                } else if (state == this.metadataPutter) {
                    this.metadataPutter = null;
                } else {
                    Logger.error(this, "onFailure() on unknown state " + state + " on " + this, (Throwable)new Exception("debug"));
                }
                if (this.finished) {
                    toFail = false;
                }
            }
            if (toFail) {
                this.fail(e, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata meta, ClientPutState state, ClientContext context) {
            RandomAccessBucket metadataBucket;
            byte[] metaBytes;
            InsertException e = null;
            if (logMINOR) {
                Logger.minor(this, "Got metadata for " + this + " from " + state);
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (SingleFileInserter.this.reportMetadataOnly) {
                    if (state != this.sfi) {
                        Logger.error(this, "Got metadata from unknown object " + state + " when expecting to report metadata");
                        return;
                    }
                    this.metaInsertSuccess = true;
                } else if (state == this.metadataPutter) {
                    Logger.error(this, "Got metadata for metadata");
                    e = new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "Did not expect to get metadata for metadata inserter", null);
                } else if (state != this.sfi) {
                    Logger.error(this, "Got metadata from unknown state " + state + " sfi=" + this.sfi + " metadataPutter=" + this.metadataPutter + " on " + this + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
                    e = new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "Got metadata from unknown state", null);
                } else {
                    if (this.metadataPutter != null) {
                        return;
                    }
                    if (this.metaInsertSuccess) {
                        return;
                    }
                }
            }
            if (SingleFileInserter.this.reportMetadataOnly) {
                SingleFileInserter.this.cb.onMetadata(meta, (ClientPutState)this, context);
                return;
            }
            if (e != null) {
                this.onFailure(e, state, context);
                return;
            }
            try {
                metaBytes = meta.writeToByteArray();
            }
            catch (MetadataUnresolvedException e1) {
                Logger.error(this, "Impossible: " + e1, (Throwable)e1);
                this.fail((InsertException)new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "MetadataUnresolvedException in SingleFileInserter.SplitHandler: " + e1, null).initCause(e1), context);
                return;
            }
            String metaPutterTargetFilename = SingleFileInserter.this.targetFilename;
            if (SingleFileInserter.this.targetFilename != null && metaBytes.length <= Short.MAX_VALUE) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put(SingleFileInserter.this.targetFilename, meta);
                meta = Metadata.mkRedirectionManifestWithMetadata(hm);
                metaPutterTargetFilename = null;
                try {
                    metaBytes = meta.writeToByteArray();
                }
                catch (MetadataUnresolvedException e1) {
                    Logger.error(this, "Impossible (2): " + e1, (Throwable)e1);
                    this.fail((InsertException)new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "MetadataUnresolvedException in SingleFileInserter.SplitHandler(2): " + e1, null).initCause(e1), context);
                    return;
                }
            }
            try {
                metadataBucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent), metaBytes);
            }
            catch (IOException e1) {
                InsertException ex = new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e1, null);
                this.fail(ex, context);
                return;
            }
            ClientMetadata m = meta.getClientMetadata();
            InsertContext.CompatibilityMode cmode = SingleFileInserter.this.ctx.getCompatibilityMode();
            if (cmode != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
                m = null;
            }
            if (SingleFileInserter.this.metadataThreshold > 0L && (long)metaBytes.length < SingleFileInserter.this.metadataThreshold) {
                SplitHandler splitHandler2 = this;
                synchronized (splitHandler2) {
                    this.metaInsertSuccess = true;
                }
                SingleFileInserter.this.cb.onMetadata(metadataBucket, state, context);
                return;
            }
            InsertBlock newBlock = new InsertBlock(metadataBucket, m, SingleFileInserter.this.block.desiredURI);
            SplitHandler splitHandler3 = this;
            synchronized (splitHandler3) {
                this.metadataPutter = new SingleFileInserter(SingleFileInserter.this.parent, this, newBlock, true, SingleFileInserter.this.ctx, SingleFileInserter.this.realTimeFlag, false, false, SingleFileInserter.this.token, SingleFileInserter.this.archiveType, true, metaPutterTargetFilename, true, this.persistent, this.origDataLength, this.origCompressedDataLength, SingleFileInserter.this.origHashes, SingleFileInserter.this.cryptoAlgorithm, SingleFileInserter.this.forceCryptoKey, SingleFileInserter.this.metadataThreshold);
                if (SingleFileInserter.this.origHashes != null) {
                    SingleFileInserter.access$802(SingleFileInserter.this, null);
                }
                if (logMINOR) {
                    Logger.minor(this, "Created metadata putter for " + this + " : " + this.metadataPutter + " bucket " + metadataBucket + " size " + metadataBucket.size());
                }
                if (!SingleFileInserter.this.ctx.earlyEncode && !this.splitInsertSuccess) {
                    return;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Putting metadata on " + this.metadataPutter + " from " + this.sfi + " (" + ((SplitFileInserter)this.sfi).getLength() + ')');
            }
            if (!this.startMetadata(context)) {
                Logger.error(this, "onMetadata() yet unable to start metadata due to not having all URIs?!?!");
                this.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "onMetadata() yet unable to start metadata due to not having all URIs", null), context);
                return;
            }
            splitHandler3 = this;
            synchronized (splitHandler3) {
                if (this.splitInsertSuccess && this.sfi != null) {
                    this.sfi = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(InsertException e, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Failing: " + e, (Throwable)e);
            }
            ClientPutState oldSFI = null;
            ClientPutState oldMetadataPutter = null;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                oldSFI = this.sfi;
                oldMetadataPutter = this.metadataPutter;
            }
            if (oldSFI != null) {
                oldSFI.cancel(context);
            }
            if (oldMetadataPutter != null) {
                oldMetadataPutter.cancel(context);
            }
            splitHandler = this;
            synchronized (splitHandler) {
                if (SingleFileInserter.this.freeData) {
                    SingleFileInserter.this.block.free();
                } else {
                    SingleFileInserter.this.block.nullData();
                }
            }
            SingleFileInserter.this.cb.onFailure(e, this, context);
        }

        @Override
        public BaseClientPutter getParent() {
            return SingleFileInserter.this.parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "onEncode() for " + this + " : " + state + " : " + key);
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (state != this.metadataPutter) {
                    if (logMINOR) {
                        Logger.minor(this, "ignored onEncode() for " + this + " : " + state);
                    }
                    return;
                }
            }
            SingleFileInserter.this.cb.onEncode(key, this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this);
            }
            ClientPutState oldSFI = null;
            ClientPutState oldMetadataPutter = null;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                oldSFI = this.sfi;
                oldMetadataPutter = this.metadataPutter;
            }
            if (oldSFI != null) {
                oldSFI.cancel(context);
            }
            if (oldMetadataPutter != null) {
                oldMetadataPutter.cancel(context);
            }
            if (SingleFileInserter.this.freeData) {
                SingleFileInserter.this.block.free();
            } else {
                SingleFileInserter.this.block.nullData();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ClientContext context) {
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (state == this.sfi) {
                    this.splitInsertSetBlocks = true;
                } else if (state == this.metadataPutter) {
                    this.metaInsertSetBlocks = true;
                } else if (logMINOR) {
                    Logger.minor(this, "Unrecognised: " + state + " in onBlockSetFinished()");
                }
                if (!this.splitInsertSetBlocks || !this.metaInsertSetBlocks) {
                    return;
                }
            }
            SingleFileInserter.this.cb.onBlockSetFinished(this, context);
        }

        @Override
        public void schedule(ClientContext context) throws InsertException {
            this.sfi.schedule(context);
        }

        @Override
        public Object getToken() {
            return SingleFileInserter.this.token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFetchable(ClientPutState state) {
            boolean meta;
            if (this.persistent && logMINOR) {
                Logger.minor(this, "onFetchable on " + this);
            }
            if (logMINOR) {
                Logger.minor(this, "onFetchable(" + state + ')');
            }
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                boolean bl = meta = state == this.metadataPutter;
                if (meta) {
                    if (!this.metaInsertStarted) {
                        Logger.error(this, "Metadata insert not started yet got onFetchable for it: " + state + " on " + this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Metadata fetchable" + (this.metaFetchable ? "" : " already"));
                    }
                    if (this.metaFetchable) {
                        return;
                    }
                    this.metaFetchable = true;
                } else {
                    if (state != this.sfi) {
                        Logger.error(this, "onFetchable for unknown state " + state);
                        return;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Data fetchable");
                    }
                    if (this.metaInsertStarted) {
                        return;
                    }
                }
            }
            if (meta) {
                SingleFileInserter.this.cb.onFetchable(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startMetadata(ClientContext context) {
            if (this.persistent && logMINOR) {
                Logger.minor(this, "startMetadata() on " + this);
            }
            try {
                ClientPutState putter;
                SplitHandler splitHandler = this;
                synchronized (splitHandler) {
                    if (this.metaInsertStarted) {
                        return true;
                    }
                    putter = this.metadataPutter;
                    if (putter == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Cannot start metadata yet: no metadataPutter");
                        }
                    } else {
                        this.metaInsertStarted = true;
                    }
                }
                if (putter != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Starting metadata inserter: " + putter + " for " + this);
                    }
                    putter.schedule(context);
                    if (logMINOR) {
                        Logger.minor(this, "Started metadata inserter: " + putter + " for " + this);
                    }
                    return true;
                }
                return false;
            }
            catch (InsertException e1) {
                Logger.error(this, "Failing " + this + " : " + e1, (Throwable)e1);
                this.fail(e1, context);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Bucket meta, ClientPutState state, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Got metadata bucket for " + this + " from " + state);
            }
            boolean freeIt = false;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.finished) {
                    return;
                }
                if (state != this.metadataPutter) {
                    if (state == this.sfi) {
                        if (this.metadataPutter != null) {
                            Logger.error(this, "Got metadata from " + this.sfi + " even though already started inserting metadata on the next layer on " + this + " !!");
                            freeIt = true;
                        } else {
                            this.metaInsertSuccess = true;
                        }
                    } else if (SingleFileInserter.this.reportMetadataOnly) {
                        if (state != this.sfi) {
                            Logger.error(this, "Got metadata from unknown object " + state + " when expecting to report metadata");
                            return;
                        }
                        this.metaInsertSuccess = true;
                    } else {
                        Logger.error(this, "Got metadata from unknown object " + state);
                        freeIt = true;
                    }
                }
            }
            if (freeIt) {
                meta.free();
                return;
            }
            SingleFileInserter.this.cb.onMetadata(meta, (ClientPutState)this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResume(ClientContext context) throws InsertException, ResumeFailedException {
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                if (this.resumed) {
                    return;
                }
                this.resumed = true;
            }
            if (this.sfi != null) {
                this.sfi.onResume(context);
            }
            if (this.metadataPutter != null) {
                this.metadataPutter.onResume(context);
            }
            if (this.sfi != null) {
                this.sfi.schedule(context);
            }
            if (this.metadataPutter != null && (SingleFileInserter.this.ctx.earlyEncode || this.sfi == null || this.metaInsertStarted)) {
                this.metadataPutter.schedule(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShutdown(ClientContext context) {
            ClientPutState metadataInserter;
            ClientPutState splitfileInserter;
            SplitHandler splitHandler = this;
            synchronized (splitHandler) {
                splitfileInserter = this.sfi;
                metadataInserter = this.metadataPutter;
            }
            if (splitfileInserter != null) {
                splitfileInserter.onShutdown(context);
            }
            if (metadataInserter != null) {
                metadataInserter.onShutdown(context);
            }
        }
    }
}

