/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.TooManyFilesInsertException;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.ManifestElement;
import freenet.support.io.ResumeFailedException;
import java.util.HashMap;
import java.util.Map;

public class PlainManifestPutter
extends BaseManifestPutter {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logDEBUG;

    public PlainManifestPutter(ClientPutCallback clientCallback, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly, boolean earlyEncode, boolean persistent, byte[] forceCryptoKey, ClientContext context) throws TooManyFilesInsertException {
        super(clientCallback, manifestElements, prioClass, target, defaultName, ctx, ClientPutter.randomiseSplitfileKeys(target, ctx, persistent), forceCryptoKey, context);
    }

    @Override
    protected void makePutHandlers(HashMap<String, Object> manifestElements, String defaultName) {
        if (logDEBUG) {
            Logger.debug(this, "Root map : " + manifestElements.size() + " elements");
        }
        this.makePutHandlers(this.getRootBuilder(), manifestElements, defaultName);
    }

    private void makePutHandlers(BaseManifestPutter.FreeFormBuilder builder, HashMap<String, Object> manifestElements, Object defaultName) {
        for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
            String name = entry.getKey();
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                HashMap subMap = (HashMap)o;
                builder.pushCurrentDir();
                builder.makeSubDirCD(name);
                this.makePutHandlers(builder, subMap, defaultName);
                builder.popCurrentDir();
                if (!logDEBUG) continue;
                Logger.debug(this, "Sub map for " + name + " : " + subMap.size() + " elements");
                continue;
            }
            ManifestElement element = (ManifestElement)o;
            builder.addElement(name, element, name.equals(defaultName));
        }
    }

    @Override
    public void innerOnResume(ClientContext context) throws ResumeFailedException {
        super.innerOnResume(context);
        this.notifyClients(context);
    }

    static {
        Logger.registerClass(PlainManifestPutter.class);
    }
}

