/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveFailureException;
import freenet.keys.FreenetURI;
import java.io.Serializable;
import java.util.HashSet;

public class ArchiveContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashSet<FreenetURI> soFar;
    final int maxArchiveLevels;
    final long maxArchiveSize;

    public ArchiveContext(long maxArchiveSize, int max) {
        this.maxArchiveLevels = max;
        this.maxArchiveSize = maxArchiveSize;
    }

    protected ArchiveContext() {
        this.maxArchiveLevels = 0;
        this.maxArchiveSize = 0L;
    }

    public synchronized void doLoopDetection(FreenetURI key) throws ArchiveFailureException {
        if (this.soFar == null) {
            this.soFar = new HashSet();
        }
        if (this.soFar.size() > this.maxArchiveLevels) {
            throw new ArchiveFailureException("Too many archive levels");
        }
        FreenetURI uri = key;
        if (!this.soFar.add(uri)) {
            throw new ArchiveFailureException("Archive loop detected");
        }
    }

    public synchronized void clear() {
        this.soFar = null;
    }
}

