/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.visitors;

import java.util.Collection;
import java.util.List;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.sequences.FilteredSequence;
import jlibs.core.graph.sequences.IterableSequence;

public class ClassSorter {
    public static List<Class<?>> sort(final Sequence<Class<?>> classes) {
        return WalkerUtil.topologicalSort(classes, new Navigator<Class<?>>(){

            @Override
            public Sequence<Class<?>> children(final Class<?> parent) {
                return new FilteredSequence(classes.copy(), new Filter<Class<?>>(){

                    @Override
                    public boolean select(Class<?> child) {
                        return child != parent && child.isAssignableFrom(parent);
                    }
                });
            }
        });
    }

    public static List<Class<?>> sort(Collection<Class<?>> classes) {
        return ClassSorter.sort(new IterableSequence(classes));
    }
}

